/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class BState extends MaybeFlagState {
	public BState(final State preState, final char flag, final CharSequence activateChars) {
		super(preState, String.valueOf(flag), activateChars);
	}

	@Override
	public boolean isFinishChar(final char c) {
		return super.isFinishChar(c) && !isG(c);
	}

	@Override
	public State metOtherChar(final char c) {
		if (isG(c)) {
			return new BgState(preState, buffer.toString() + c, activateChars);
		}
		return super.metOtherChar(c);
	}

	private static boolean isG(final char c) {
		return c == 'g' || c == 'G';
	}
}
