/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public abstract class BaseState implements State {
	protected final State preState;
	protected final StringBuilder buffer;

	public BaseState(final State preState) {
		this(preState, new StringBuilder());
	}

	public BaseState(final State preState, final StringBuilder initBuffer) {
		this.preState = preState;
		buffer = new StringBuilder(initBuffer);
	}

	public BaseState(final State preState, final char curChar) {
		this(preState);
		buffer.append(curChar);
	}

	public BaseState(final State preState, final StringBuilder initBuffer, final char curChar) {
		this(preState, initBuffer);
		buffer.append(curChar);
	}

	@Override
	public State preState() {
		return preState;
	}

	@Override
	public StringBuilder buffer() {
		return buffer;
	}
}
