/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

import org.jsoup.nodes.Element;

/**
 * 普通文本状态。
 */
public class CommonContentState extends BaseState {
	private final Element curDom;

	public CommonContentState(final State preState, final Element curDom) {
		super(preState);
		this.curDom = curDom;
	}

	@Override
	public State preState() {
		return preState == null ? this : preState;
	}

	@Override
	public Element dom() {
		return curDom;
	}

	@Override
	public State metNewline(final char newlineChar) {
		checkHr();
		return super.metNewline(newlineChar);
	}

	@Override
	public void end() {
		checkHr();
		flushBuffer();
		final var preState = preState();
		if (preState != null && !equals(preState)) {
			preState.end();
		}
	}

	protected boolean checkHr() {
		return Helper.checkHr(this);
	}
}
