/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public interface Const {
	char SLASH = '\\';
	String SLASH_STR = String.valueOf(SLASH);

	char COLON = ':';
	String COLON_STR = String.valueOf(COLON);
	char LEFT_PARENTHESIS = '(';
	String LEFT_PARENTHESIS_STR = String.valueOf(LEFT_PARENTHESIS);
	char RIGHT_PARENTHESIS = ')';
	String RIGHT_PARENTHESIS_STR = String.valueOf(RIGHT_PARENTHESIS);
	char PIPE = '|';
	String PIPE_STR = String.valueOf(PIPE);

	char NEWLINE = '\n';
	String NEWLINE_STR = String.valueOf(NEWLINE);
	char HYPHEN = '-';
	String HYPHEN_STR = String.valueOf(HYPHEN);

	char DOT = '.';
	String DOT_STR = String.valueOf(DOT);
	char HASH = '#';
	String HASH_STR = String.valueOf(HASH);

	char LEFT_SQUARE_BRACKET = '[';
	String LEFT_SQUARE_BRACKET_STR = String.valueOf(LEFT_SQUARE_BRACKET);
	char RIGHT_SQUARE_BRACKET = ']';
	String RIGHT_SQUARE_BRACKET_STR = String.valueOf(RIGHT_SQUARE_BRACKET);

	//业务
	char DEFAULT_ACTIVATE_SYMBOL = SLASH;
	String DEFAULT_ACTIVATE_SYMBOL_STR = SLASH_STR;

	char DEFAULT_SINGLELINE_FLAG = COLON;
	String DEFAULT_SINGLELINE_FLAG_STR = COLON_STR;
	char DEFAULT_MULTILINE_FLAG = LEFT_PARENTHESIS;
	String DEFAULT_MULTILINE_FLAG_STR = LEFT_PARENTHESIS_STR;
	char DEFAULT_MULTILINE_END_FLAG = RIGHT_PARENTHESIS;
	String DEFAULT_MULTILINE_END_FLAG_STR = RIGHT_PARENTHESIS_STR;
	char DEFAULT_SINGLELINE_QUIT_FLAG = PIPE;
	String DEFAULT_SINGLELINE_QUIT_FLAG_STR = PIPE_STR;

	char DEFAULT_HR_FLAG = HYPHEN;
	String DEFAULT_HR_FLAG_STR = HYPHEN_STR;

	char DEFAULT_OL_FLAG = HASH;
	String DEFAULT_OL_FLAG_STR = HASH_STR;
	char DEFAULT_UL_FLAG = DOT;
	String DEFAULT_UL_FLAG_STR = DOT_STR;

	char DEFAULT_TABLE_FLAG = LEFT_SQUARE_BRACKET;
	String DEFAULT_TABLE_FLAG_STR = LEFT_SQUARE_BRACKET_STR;
	char DEFAULT_TABLE_END_FLAG = RIGHT_SQUARE_BRACKET;
	String DEFAULT_TABLE_END_FLAG_STR = RIGHT_SQUARE_BRACKET_STR;
}
