/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class InFormattingActivateState extends ActivateState {
	public InFormattingActivateState(final FormattingState preState, final char activateChar) {
		super(preState, activateChar);
	}

	@Override
	public boolean isFinishChar(final char c) {
		final var formattingContentState = (FormattingState) preState;
		//|和)不是本状态的结束符，是前置状态的，需要特殊处理。
		//注：本状态结束意味着回滚（中间状态的结束是回滚），即此路不通，需要把buffer还回前置状态。
		// 而|和)表示“前置状态结束”，即此路是通的，要跳转到下一个状态。
		if (formattingContentState.isSingleline) {
			if (isSinglelineEnd(c)) {
				return false;
			}
		} else {
			if (isMultilineEnd(c)) {
				return false;
			}
		}
		return super.isFinishChar(c);
	}

	@Override
	public State metOtherChar(final char c) {
		final var formattingContentState = (FormattingState) preState;
		if (formattingContentState.isSingleline && isSinglelineEnd(c)) {
			return finishFormatting(c);
		} else if (!formattingContentState.isSingleline && isMultilineEnd(c)) {
			return finishFormatting(c);
		}
		return super.metOtherChar(c);
	}

	protected State finishFormatting(final char c) {
		return preState.finish(c);
	}

	protected static boolean isSinglelineEnd(final char c) {
		return c == '|';
	}

	protected static boolean isMultilineEnd(final char c) {
		return c == ')';
	}
}
