/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

import java.util.Arrays;

public class MaybeColorState extends MaybeFlagState {
	public MaybeColorState(final State preState, final String flag, final CharSequence activateChars) {
		super(preState, flag, activateChars);
	}

	@Override
	protected boolean maybeFlag(final String flag) {
		if (flag.length() <= 1) {
			return Const.DEFAULT_OL_FLAG_STR.equals(flag);
		}
		if (canBeColor(flag)) {
			return true;
		}
		return super.maybeFlag(flag);
	}

	@Override
	protected void checkIsReady() {
		super.checkIsReady();
		if (!isReady) {
			isReady = canBeColor(buffer.toString());
		}
	}

	private static boolean canBeColor(final String flag) {
		final var index = flag.indexOf('#');
		if (index == -1) {
			return false;
		}
		final var maybeColorStr = flag.substring(index + 1).toLowerCase();
		if (Helper.isHex(maybeColorStr)) {
			return true;
		}
		return Arrays.stream(Helper.NAMED_COLORS)//
				.anyMatch(namedColor -> namedColor.startsWith(maybeColorStr));
	}

	@Override
	protected State next(final char c, final boolean isSingleline) {
		final var newDom = Helper.setCssColor(buffer.toString());
		if (newDom == null) {
			return finish(c);
		}
		preState.flushBuffer();
		newDom.appendTo(dom());
		return new FormattingState(preState, newDom, isSingleline);
	}
}
