/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class MaybeFlagState extends NotStartState implements MiddleState {
	protected final CharSequence activateChars;//通常是\，可能前部带有空白字符。
	protected boolean isReady;

	public MaybeFlagState(final State preState, final String flag, final CharSequence activateChars) {
		super(preState);
		setFlag(flag);
		this.activateChars = activateChars;
	}

	private void setFlag(final String flag) {
		clearBuffer();
		buffer.append(flag);
		checkIsReady();
	}

	@Override
	public State metChar(final char c) {
		final var rt = super.metChar(c);
		checkIsReady();
		return rt;
	}

	protected State next(final char c, final boolean isSingleline) {
		return new FormattingState(preState, buffer, isSingleline);
	}

	@Override
	public State metActivateChar(final char activateChar) {
		return finish(activateChar);
	}

	@Override
	public State metNewline(final char newlineChar) {
		return finish(newlineChar);
	}

	@Override
	public boolean isFinishChar(final char c) {
		return !(isReady && (c == ':' || c == '(')) && !maybeFlag(buffer.toString() + c);
	}

	@Override
	public State finish(final char finishChar) {
		addActivateChars();
		return MiddleState.super.finish(finishChar);
	}

	@Override
	public State metOtherChar(final char c) {
		if (isReady) {
			if (isSinglelineChar(c)) {
				return next(c, true);
			} else if (isMultilineChar(c)) {
				return next(c, false);
			}
		}
		return super.metOtherChar(c);
	}

	protected boolean maybeFlag(final String flag) {
		return Helper.maybeFlag(flag);
	}

	@Override
	public void end() {
		addActivateChars();
		super.end();
	}

	private void addActivateChars() {
		buffer.insert(0, activateChars);
	}

	protected void checkIsReady() {
		isReady = Helper.isFlagReady(buffer.toString());
	}

	public boolean isReady() {
		return isReady;
	}

	private static boolean isSinglelineChar(final char c) {
		return c == ':';
	}

	private static boolean isMultilineChar(final char c) {
		return c == '(';
	}
}