/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.BState;
import cool.document.qtmd.HashState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.IState;
import cool.document.qtmd.MaybeFlagState;
import cool.document.qtmd.MaybeLiState;
import cool.document.qtmd.MaybeLinkState;
import cool.document.qtmd.MiddleState;
import cool.document.qtmd.NotStartState;
import cool.document.qtmd.State;
import cool.document.qtmd.TableState;

public class ActivateState
extends NotStartState
implements MiddleState {
    public ActivateState(State preState, Object activateChars) {
        super(preState);
        this.buffer.append(activateChars);
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new MultiEscapeState(this.preState, this.buffer);
    }

    @Override
    public State metNewline(char newlineChar) {
        return this.finish(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return !Helper.maybeFlag(String.valueOf(c));
    }

    @Override
    public State metOtherChar(char c) {
        return switch (c) {
            case '[' -> this.metLeftSquareBracket(c);
            case '#' -> this.metHash(c);
            case '.' -> this.metDot(c);
            case 'L', 'l' -> new MaybeLinkState(this.preState, c, (CharSequence)this.buffer);
            case 'I', 'i' -> new IState(this.preState, c, (CharSequence)this.buffer);
            case 'B', 'b' -> new BState(this.preState, c, (CharSequence)this.buffer);
            default -> new MaybeFlagState(this.preState, String.valueOf(c), this.buffer);
        };
    }

    protected TableState metLeftSquareBracket(char c) {
        return new TableState(this.preState, c);
    }

    protected HashState metHash(char c) {
        return new HashState(this.preState, (CharSequence)this.buffer, c);
    }

    protected MaybeLiState metDot(char c) {
        return new MaybeLiState(this.preState, (CharSequence)this.buffer, c);
    }

    public static class MultiEscapeState
    extends NotStartState
    implements MiddleState {
        public MultiEscapeState(State preState, StringBuilder initBuffer) {
            super(preState, initBuffer);
        }

        @Override
        public State metNewline(char newlineChar) {
            return this.finish(newlineChar);
        }

        @Override
        public State metActivateChar(char activateChar) {
            return this.addChar(activateChar);
        }

        @Override
        public boolean isFinishChar(char c) {
            return c != '\\';
        }
    }
}

