/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.Helper;
import cool.document.qtmd.InFormattingActivateState;
import cool.document.qtmd.NotStartState;
import cool.document.qtmd.State;
import org.jsoup.nodes.Element;

public class FormattingState
extends NotStartState {
    protected final boolean isSingleline;
    protected final String flag;
    protected final Element dom;

    public FormattingState(State preState, CharSequence flag, boolean isSingleline) {
        this(preState, preState.dom(), flag, isSingleline);
    }

    public FormattingState(State preState, Element parentDom, CharSequence flag, boolean isSingleline) {
        this(preState, FormattingState.createDom(preState, flag.toString(), isSingleline, parentDom), isSingleline);
    }

    public FormattingState(State preState, Element dom, boolean isSingleline) {
        super(preState);
        this.flag = dom.tagName();
        this.isSingleline = isSingleline;
        this.dom = dom;
    }

    private static Element createDom(State preState, String flag, boolean isSingleline, Element parentDom) {
        preState.flushBuffer();
        if (!flag.isEmpty()) {
            return Helper.newDom(flag, isSingleline).appendTo(parentDom);
        }
        return parentDom;
    }

    @Override
    public Element dom() {
        return this.dom;
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new InFormattingActivateState(this, activateChar);
    }

    @Override
    public State metNewline(char newlineChar) {
        if (this.isSingleline) {
            return this.finish(newlineChar);
        }
        return super.metNewline(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return this.isSingleline && this.isNewline(c);
    }

    @Override
    public State finish(char finishChar) {
        this.flushBuffer();
        return this.handleFinishChar(finishChar);
    }

    protected State handleFinishChar(char finishChar) {
        if (this.isNewline(finishChar)) {
            return this.preState().metChar(finishChar);
        }
        return this.preState();
    }
}

