/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ActivateState;
import cool.document.qtmd.FormattingState;
import cool.document.qtmd.HashState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.InFormattingActivateState;
import cool.document.qtmd.MiddleState;
import cool.document.qtmd.NotStartState;
import cool.document.qtmd.State;
import java.util.List;
import me.magicall.\u8d35\u9633DearSun.exception.UnknownException;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class LiState
extends FormattingState {
    protected final int indentCount;
    protected final State preState;
    protected final Element dom;

    public LiState(State preState, CharSequence activateChars, CharSequence flag, boolean isSingleline) {
        super(preState, flag, isSingleline);
        Element liParentDom = ((FormattingState)this).dom;
        if (preState instanceof LiContentFinishedState) {
            LiContentFinishedState liContentFinishedState = (LiContentFinishedState)preState;
            this.indentCount = LiState.calIndent(liContentFinishedState.clearBuffer() + activateChars);
            int delta = this.indentCount - liContentFinishedState.liState().indentCount;
            if (delta > 0) {
                this.preState = liContentFinishedState;
                this.dom = liParentDom.appendElement("li");
            } else {
                Element curLiGrandparentDom = preState.dom();
                Element preLiParentDom = curLiGrandparentDom.parent();
                if (preLiParentDom == null) {
                    throw new UnknownException();
                }
                liParentDom.remove();
                if (delta == 0) {
                    State preLi = liContentFinishedState.preState;
                    this.preState = preLi.preState();
                    this.dom = preLiParentDom.appendElement("li");
                } else {
                    State preLiState = liContentFinishedState.preState();
                    State preStateOfFirstSiblingLi = preLiState.preState();
                    while (preStateOfFirstSiblingLi instanceof LiContentFinishedState) {
                        LiContentFinishedState s = (LiContentFinishedState)preStateOfFirstSiblingLi;
                        preLiState = s.preState;
                        if (((LiState)preLiState).indentCount < this.indentCount) break;
                        preStateOfFirstSiblingLi = preLiState.preState();
                    }
                    this.preState = preStateOfFirstSiblingLi;
                    Element realParentDom = preLiState.dom().parent();
                    if (realParentDom == null) {
                        throw new UnknownException();
                    }
                    this.dom = realParentDom.appendElement("li");
                }
            }
        } else {
            this.preState = preState;
            this.dom = liParentDom.appendElement("li");
            List siblingNodes = liParentDom.siblingNodes();
            if (siblingNodes.isEmpty()) {
                this.indentCount = LiState.calIndent(activateChars);
            } else {
                Node lastTextNode = (Node)siblingNodes.get(siblingNodes.size() - 1);
                this.indentCount = LiState.calIndent(lastTextNode.toString() + activateChars);
            }
        }
    }

    protected static int calIndent(CharSequence activateChars) {
        return Helper.calIndent(activateChars.subSequence(0, activateChars.length() - 1).toString());
    }

    @Override
    public State preState() {
        return this.preState;
    }

    @Override
    public Element dom() {
        return this.dom;
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new InLiActivatingState(this, activateChar);
    }

    @Override
    public State metNewline(char newlineChar) {
        if (this.isSingleline) {
            this.flushBuffer();
            return new UnderLiState((State)this, newlineChar);
        }
        return super.metNewline(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return false;
    }

    public static class LiContentFinishedState
    extends NotStartState
    implements MaybeFollowingNextLiState {
        protected final char liContentFinishChar;

        public LiContentFinishedState(State preState, char liContentFinishChar, CharSequence leadingChars) {
            super(preState);
            this.liContentFinishChar = liContentFinishChar;
            this.buffer.append(leadingChars);
            preState.flushBuffer();
        }

        public LiContentFinishedState(State preState, char liContentFinishChar) {
            super(preState);
            this.liContentFinishChar = liContentFinishChar;
            preState.flushBuffer();
        }

        @Override
        public State metNewline(char newlineChar) {
            return new UnderLiState(this.preState, this.liContentFinishChar, this.buffer.toString(), newlineChar);
        }

        @Override
        public char liContentFinishChar() {
            return this.liContentFinishChar;
        }
    }

    public static class InLiActivatingState
    extends InFormattingActivateState {
        private final LiState liState;

        public InLiActivatingState(LiState preState, char activateChar) {
            super(preState, activateChar);
            this.liState = preState;
        }

        @Override
        public State finish(char finishChar) {
            if (this.willConsumeFinishChar(finishChar)) {
                return this.preState();
            }
            return this.preState().metChar(finishChar);
        }

        @Override
        protected State finishFormatting(char c) {
            return new LiContentFinishedState((State)this.liState, c);
        }

        @Override
        protected HashState metHash(char c) {
            return new HashState((State)this.liState, (CharSequence)this.buffer, c);
        }
    }

    public static class UnderLiState
    extends LiContentFinishedState
    implements MaybeFollowingNextLiState {
        public UnderLiState(State preState, char liContentFinishChar, CharSequence leadingChars, char newlineChar) {
            super(preState, liContentFinishChar, leadingChars);
            this.buffer.append(newlineChar);
        }

        public UnderLiState(State preState, char liContentFinishChar) {
            super(preState, liContentFinishChar);
        }

        @Override
        public State metNewline(char newlineChar) {
            return this.finishLi(newlineChar);
        }

        @Override
        public ActivateState metActivateChar(char activateChar) {
            return new UnderLiActivateState(this, activateChar);
        }
    }

    public static class UnderLiActivateState
    extends ActivateState
    implements MaybeFollowingNextLiState {
        public UnderLiActivateState(UnderLiState preState, char activateChar) {
            super((State)preState, Character.valueOf(activateChar));
        }

        @Override
        public State metOtherChar(char c) {
            if (c == '#' || c == '.') {
                return super.metOtherChar(c);
            }
            return this.finish(c);
        }

        @Override
        public char liContentFinishChar() {
            return ((MaybeFollowingNextLiState)this.preState).liContentFinishChar();
        }
    }

    public static interface MaybeFollowingNextLiState
    extends MiddleState {
        default public LiState liState() {
            State preState = this.preState();
            if (preState instanceof LiState) {
                LiState liState = (LiState)preState;
                return liState;
            }
            if (preState instanceof MaybeFollowingNextLiState) {
                MaybeFollowingNextLiState maybeFollowingNextLiState = (MaybeFollowingNextLiState)preState;
                return maybeFollowingNextLiState.liState();
            }
            throw new UnknownException();
        }

        @Override
        default public State metActivateChar(char activateChar) {
            return this.finishLi(activateChar);
        }

        @Override
        default public State metNewline(char newlineChar) {
            return this.finishLi(newlineChar);
        }

        @Override
        default public State finish(char finishChar) {
            return this.finishLi(finishChar);
        }

        default public State finishLi(char c) {
            return this.finishLi0().metChars(this.buffer()).metChar(c);
        }

        default public State finishLi0() {
            return this.liState().finish(this.liContentFinishChar());
        }

        public char liContentFinishChar();

        @Override
        default public State metOtherChar(char c) {
            if (Character.isWhitespace(c)) {
                return this.addChar(c);
            }
            return this.finishLi(c);
        }

        @Override
        default public State flushBuffer() {
            return this;
        }
    }
}

