/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.Const;
import cool.document.qtmd.FormattingState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.MaybeFlagState;
import cool.document.qtmd.State;
import java.util.Arrays;
import org.jsoup.nodes.Element;

public class MaybeColorState
extends MaybeFlagState {
    public MaybeColorState(State preState, String flag, CharSequence activateChars) {
        super(preState, flag, activateChars);
    }

    @Override
    protected boolean maybeFlag(String flag) {
        if (flag.length() <= 1) {
            return Const.DEFAULT_OL_FLAG_STR.equals(flag);
        }
        if (MaybeColorState.canBeColor(flag)) {
            return true;
        }
        return super.maybeFlag(flag);
    }

    @Override
    protected void checkIsReady() {
        super.checkIsReady();
        if (!this.isReady) {
            this.isReady = MaybeColorState.canBeColor(this.buffer.toString());
        }
    }

    private static boolean canBeColor(String flag) {
        int index = flag.indexOf(35);
        if (index == -1) {
            return false;
        }
        String maybeColorStr = flag.substring(index + 1).toLowerCase();
        if (Helper.isHex(maybeColorStr)) {
            return true;
        }
        return Arrays.stream(Helper.NAMED_COLORS).anyMatch(namedColor -> namedColor.startsWith(maybeColorStr));
    }

    @Override
    protected State next(char c, boolean isSingleline) {
        Element newDom = Helper.setCssColor(this.buffer.toString());
        if (newDom == null) {
            return this.finish(c);
        }
        this.preState.flushBuffer();
        newDom.appendTo(this.dom());
        return new FormattingState(this.preState, newDom, isSingleline);
    }
}

