/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.FormattingState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.MiddleState;
import cool.document.qtmd.NotStartState;
import cool.document.qtmd.State;

public class MaybeFlagState
extends NotStartState
implements MiddleState {
    protected final CharSequence activateChars;
    protected boolean isReady;

    public MaybeFlagState(State preState, String flag, CharSequence activateChars) {
        super(preState);
        this.setFlag(flag);
        this.activateChars = activateChars;
    }

    private void setFlag(String flag) {
        this.clearBuffer();
        this.buffer.append(flag);
        this.checkIsReady();
    }

    @Override
    public State metChar(char c) {
        State rt = super.metChar(c);
        this.checkIsReady();
        return rt;
    }

    protected State next(char c, boolean isSingleline) {
        return new FormattingState(this.preState, (CharSequence)this.buffer, isSingleline);
    }

    @Override
    public State metActivateChar(char activateChar) {
        return this.finish(activateChar);
    }

    @Override
    public State metNewline(char newlineChar) {
        return this.finish(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return (!this.isReady || c != ':' && c != '(') && !this.maybeFlag(this.buffer.toString() + c);
    }

    @Override
    public State finish(char finishChar) {
        this.addActivateChars();
        return MiddleState.super.finish(finishChar);
    }

    @Override
    public State metOtherChar(char c) {
        if (this.isReady) {
            if (MaybeFlagState.isSinglelineChar(c)) {
                return this.next(c, true);
            }
            if (MaybeFlagState.isMultilineChar(c)) {
                return this.next(c, false);
            }
        }
        return super.metOtherChar(c);
    }

    protected boolean maybeFlag(String flag) {
        return Helper.maybeFlag(flag);
    }

    @Override
    public void end() {
        this.addActivateChars();
        super.end();
    }

    private void addActivateChars() {
        this.buffer.insert(0, this.activateChars);
    }

    protected void checkIsReady() {
        this.isReady = Helper.isFlagReady(this.buffer.toString());
    }

    public boolean isReady() {
        return this.isReady;
    }

    private static boolean isSinglelineChar(char c) {
        return c == ':';
    }

    private static boolean isMultilineChar(char c) {
        return c == '(';
    }
}

