/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ActivateState;
import cool.document.qtmd.Helper;
import org.jsoup.nodes.Element;

public interface State {
    public State preState();

    public Element dom();

    public StringBuilder buffer();

    default public State metChars(CharSequence s) {
        State curState = this;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            curState = curState.metChar(c);
        }
        return curState;
    }

    default public State metChar(char c) {
        if (this.isActivateChar(c)) {
            return this.metActivateChar(c);
        }
        if (this.isNewline(c)) {
            return this.metNewline(c);
        }
        if (this.isFinishChar(c)) {
            return this.finish(c);
        }
        return this.metOtherChar(c);
    }

    default public boolean isActivateChar(char c) {
        return c == '\\';
    }

    default public State metActivateChar(char activateChar) {
        return new ActivateState(this, Character.valueOf(activateChar));
    }

    default public boolean isNewline(char c) {
        return Helper.isNewline(c);
    }

    default public State metNewline(char newlineChar) {
        return this.addChar(newlineChar);
    }

    default public boolean isFinishChar(char c) {
        return false;
    }

    default public State finish(char finishChar) {
        this.flushBuffer();
        return this.preState();
    }

    default public State metOtherChar(char c) {
        return this.addChar(c);
    }

    default public State addChar(char c) {
        this.buffer().append(c);
        return this;
    }

    default public State addChars(CharSequence s) {
        this.buffer().append(s);
        return this;
    }

    default public void end() {
        this.flushBuffer();
        this.preState().end();
    }

    default public State flushBuffer() {
        Helper.flushToDom(this.buffer(), this.dom());
        return this;
    }

    default public String clearBuffer() {
        StringBuilder buffer = this.buffer();
        String rt = buffer.toString();
        buffer.setLength(0);
        return rt;
    }
}

