/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ActivateState;
import cool.document.qtmd.FormattingState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.MiddleState;
import cool.document.qtmd.NotStartState;
import cool.document.qtmd.State;
import me.magicall.\u8d35\u9633DearSun.exception.UnknownException;
import org.jsoup.nodes.Element;

public class TableState
extends FormattingState {
    protected final Element tableDom = super.dom();
    protected Element tdDom;

    public TableState(State preState, char flag) {
        super(preState, String.valueOf(flag), false);
        Helper.attr(this.tableDom, "border", "1");
        Element tr = Helper.newTr(this.tableDom);
        this.tdDom = Helper.newTd(tr);
    }

    @Override
    public Element dom() {
        return this.tdDom;
    }

    @Override
    public ActivateState metActivateChar(char activateChar) {
        return new InTdActivateState(this, activateChar);
    }

    public static class InTdActivateState
    extends ActivateState {
        public InTdActivateState(TableState preState, char activateChar) {
            super((State)preState, Character.valueOf(activateChar));
        }

        @Override
        public boolean isFinishChar(char c) {
            return !InTdActivateState.isTdEnd(c) && !InTdActivateState.isTrEnd(c) && super.isFinishChar(c);
        }

        @Override
        public State metOtherChar(char c) {
            if (InTdActivateState.isTrEnd(c)) {
                return this.endTr(c);
            }
            if (InTdActivateState.isTdEnd(c)) {
                return this.newTd();
            }
            return super.metOtherChar(c);
        }

        private State endTr(char c) {
            this.endTd();
            return new TableRowEndedState((TableState)this.preState, c);
        }

        private State newTd() {
            Element tr = this.endTd();
            this.tableState().tdDom = Helper.newTd(tr);
            return this.preState;
        }

        private Element endTd() {
            this.preState.flushBuffer();
            Element tr = this.tableState().tdDom.parent();
            if (tr == null) {
                throw new UnknownException();
            }
            return tr;
        }

        private TableState tableState() {
            return (TableState)this.preState();
        }

        private static boolean isTdEnd(char c) {
            return c == '|';
        }

        private static boolean isTrEnd(char c) {
            return c == ']';
        }
    }

    public static class UnderTrActivateState
    extends ActivateState
    implements TrFinishedState {
        private final char endTrChar;

        public UnderTrActivateState(TableState preState, char endTrChar, String activateChars) {
            super((State)preState, activateChars);
            this.endTrChar = endTrChar;
        }

        @Override
        public State metOtherChar(char c) {
            TableState tableState = this.tableState();
            if (UnderTrActivateState.isTrStart(c)) {
                Element tr = Helper.newTr(tableState.tableDom);
                tableState.tdDom = Helper.newTd(tr);
                return tableState;
            }
            return this.finishTable(c);
        }

        @Override
        public char finishChar() {
            return this.endTrChar;
        }

        private static boolean isTrStart(char c) {
            return c == '[';
        }
    }

    public static class UnderTrState
    extends NotStartState
    implements TrFinishedState {
        private final char endTrChar;

        public UnderTrState(TableState preState, char endTrChar, Object enterChars) {
            super(preState);
            this.endTrChar = endTrChar;
            this.buffer.append(enterChars);
        }

        @Override
        public ActivateState metActivateChar(char activateChar) {
            return new UnderTrActivateState(this.tableState(), this.endTrChar, this.buffer.toString() + activateChar);
        }

        @Override
        public char finishChar() {
            return this.endTrChar;
        }
    }

    public static class TableRowEndedState
    extends NotStartState
    implements TrFinishedState {
        private final char endTrChar;

        public TableRowEndedState(TableState preState, char endTrChar) {
            super(preState);
            this.endTrChar = endTrChar;
        }

        @Override
        public State metNewline(char newlineChar) {
            return new UnderTrState(this.tableState(), this.endTrChar, this.buffer.toString() + newlineChar);
        }

        @Override
        public char finishChar() {
            return this.endTrChar;
        }
    }

    public static interface TrFinishedState
    extends MiddleState {
        default public TableState tableState() {
            return (TableState)this.preState();
        }

        @Override
        default public State metActivateChar(char activateChar) {
            return this.finishTable(activateChar);
        }

        @Override
        default public State metNewline(char newlineChar) {
            return this.finishTable(newlineChar);
        }

        @Override
        default public State metOtherChar(char c) {
            if (Character.isWhitespace(c)) {
                return this.addChar(c);
            }
            return this.finishTable(c);
        }

        default public State finishTable(char finishChar) {
            return this.tableState().finish(this.finishChar()).metChars(this.buffer()).metChar(finishChar);
        }

        public char finishChar();
    }
}

