/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class ActivateState extends BaseMiddleState {
	public ActivateState(final ContentState stateAfterFinish, final Object activateChars) {
		super(stateAfterFinish);
		buffer.append(activateChars);//buffer可能是一堆空白字符，最后一个\
	}

	@Override
	public State metActivateChar(final char activateChar) {
		return new MultiEscapeState(stateAfterFinish, buffer);
	}

	@Override
	public State metNewline(final char newlineChar) {
		return finish(newlineChar);
	}

	@Override
	public boolean isFinishChar(final char c) {
		return !Helper.maybeFlag(String.valueOf(c));
	}

	@Override
	public State metOtherChar(final char c) {
		return switch (c) {
			case '[' -> metLeftSquareBracket(c);
			case '#' -> metHash(c);
			case '.' -> metDot(c);
			case 'l', 'L' -> new MaybeLinkState(stateAfterFinish, c, buffer);
			case 'i', 'I' -> new IState(stateAfterFinish, c, buffer);
			case 'b', 'B' -> new BState(stateAfterFinish, c, buffer);
			default -> new BaseMaybeFlagState(stateAfterFinish, String.valueOf(c), buffer);
		};
	}

	protected TableState metLeftSquareBracket(final char c) {
		return new TableState(stateAfterFinish, c);
	}

	protected HashState metHash(final char c) {
		return new HashState(stateAfterFinish, buffer, c);
	}

	protected MaybeLiState metDot(final char c) {
		return new MaybeUlState(stateAfterFinish, buffer, c);
	}

	//==========================================================

	/**
	 * 多转义符状态。简单起见，多转义符视为普通文本，此时不再接受标记。
	 */
	public static class MultiEscapeState extends BaseMiddleState {
		public MultiEscapeState(final ContentState stateAfterFinish, final StringBuilder initBuffer) {
			super(stateAfterFinish, initBuffer);
		}

		@Override
		public State metNewline(final char newlineChar) {
			return finish(newlineChar);
		}

		@Override
		public State metActivateChar(final char activateChar) {
			return addChar(activateChar);
		}

		@Override
		public boolean isFinishChar(final char c) {
			return c != '\\';
		}
	}
}
