/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public interface MaybeFlagState extends MiddleState {

	@Override
	default State metNewline(final char newlineChar) {
		return finish(newlineChar);
	}

	@Override
	default boolean isFinishChar(final char c) {
		if (isReady()) {
			if (c == ':' || c == '(') {
				return false;
			}
		}
		return !Helper.maybeFlag(buffer().toString() + c);
	}

	@Override
	default State metOtherChar(final char c) {
		if (isReady()) {
			if (isSinglelineChar(c)) {
				return next(c, true);
			} else if (isMultilineChar(c)) {
				return next(c, false);
			}
		}
		return MiddleState.super.metOtherChar(c);
	}

	default State next(final char c, final boolean isSingleline) {
		return new FormattingState(stateAfterFinish(), buffer(), isSingleline);
	}

	CharSequence activateChars();

	default boolean isReady() {
		return Helper.isFlagReady(buffer().toString());
	}

	static boolean isSinglelineChar(final char c) {
		return c == ':';
	}

	static boolean isMultilineChar(final char c) {
		return c == '(';
	}
}
