/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ContentState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.InFormattingActivateState;
import cool.document.qtmd.State;
import org.jsoup.nodes.Element;

public class FormattingState
extends ContentState {
    protected final boolean isSingleline;
    protected final String flag;

    public FormattingState(ContentState stateAfterFinish, CharSequence flag, boolean isSingleline) {
        this(stateAfterFinish, FormattingState.createDom(stateAfterFinish, flag.toString(), isSingleline, stateAfterFinish.dom()), isSingleline);
    }

    public FormattingState(ContentState stateAfterFinish, Element dom, boolean isSingleline) {
        super(stateAfterFinish, dom);
        this.flag = dom.tagName();
        this.isSingleline = isSingleline;
    }

    private static Element createDom(State stateAfterFinish, String flag, boolean isSingleline, Element parentDom) {
        stateAfterFinish.flushBuffer();
        if (!flag.isEmpty()) {
            return Helper.newDom(flag, isSingleline).appendTo(parentDom);
        }
        return parentDom;
    }

    public boolean isSingleline() {
        return this.isSingleline;
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new InFormattingActivateState(this, activateChar);
    }

    @Override
    public State metNewline(char newlineChar) {
        if (this.isSingleline()) {
            return this.finish(newlineChar);
        }
        return super.metNewline(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return this.isSingleline() && this.isNewline(c);
    }

    @Override
    public State finish(char finishChar) {
        this.flushBuffer();
        return this.handleFinishChar(finishChar);
    }

    protected State handleFinishChar(char finishChar) {
        if (this.isNewline(finishChar)) {
            return this.stateAfterFinish().metChar(finishChar);
        }
        return this.stateAfterFinish();
    }
}

