/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import com.google.common.collect.Maps;
import cool.document.qtmd.ContentState;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.magicall.\u8d35\u9633DearSun.exception.NullValException;
import me.magicall.\u8d35\u9633DearSun.exception.UnknownException;
import org.jsoup.nodes.Element;

public class Helper {
    public static final String[] NAMED_COLORS = new String[]{"aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen"};
    private static final List<String> TAGS_CAN_HAVE_HR = Arrays.asList("body", "div", "section", "article", "aside", "header", "footer", "nav", "h1", "h2", "h3", "h4", "h5", "h6", "blockquote", "p", "li", "th", "td", "fieldset");
    public static final String EMAIL_PATTERN = "^[\\p{L}\\p{N}._%+-]+@[\\p{L}\\p{N}.-]+\\.\\p{L}{2,}$";
    private static final Map<String, Object> FLAG_SYMBOL_TO_TAG = Maps.newHashMap();

    public static String colorOf(String name) {
        String n = name.toLowerCase();
        return Stream.of(NAMED_COLORS).filter(e -> e.equals(n)).findFirst().orElse(null);
    }

    public static boolean isColorName(String s) {
        return Helper.colorOf(s) != null;
    }

    public static String parseColor(String maybeColor) {
        if (Helper.isColorName(maybeColor)) {
            return maybeColor;
        }
        if (Helper.isHex(maybeColor)) {
            String color = switch (maybeColor.length()) {
                case 1, 2 -> maybeColor.repeat(3);
                case 3, 4, 6, 8 -> maybeColor;
                default -> null;
            };
            return color == null ? null : "#" + color;
        }
        return null;
    }

    public static Element setCssColor(String maybeColorFlag) {
        String cssName;
        int index = maybeColorFlag.indexOf(35);
        if (index < 0) {
            throw new UnknownException();
        }
        if (index == 0) {
            cssName = "color";
        } else if ("bg".equals(maybeColorFlag.substring(0, index))) {
            cssName = "background-color";
        } else {
            throw new UnknownException();
        }
        String color = Helper.parseColor(maybeColorFlag.substring(index + 1));
        if (color == null) {
            return null;
        }
        Element span = new Element("span");
        Helper.css(span, cssName, color);
        return span;
    }

    public static boolean isHexCharacter(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'a' && c <= 'f') {
            return true;
        }
        return c >= 'A' && c <= 'F';
    }

    public static boolean isHex(String s) {
        return IntStream.range(0, s.length()).allMatch(i -> Helper.isHexCharacter(s.charAt(i)));
    }

    public static boolean canHaveHr(String tagName) {
        return TAGS_CAN_HAVE_HR.contains(tagName.toLowerCase());
    }

    public static boolean isEmail(CharSequence s) {
        return Pattern.matches(EMAIL_PATTERN, s);
    }

    public static URL url(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Element newDom(String flagSymbol, boolean isSingleline) {
        String flag = flagSymbol.toLowerCase();
        Object domPattern = FLAG_SYMBOL_TO_TAG.get(flag);
        if (domPattern instanceof String) {
            String tagName = (String)domPattern;
            if (tagName.contains(" ")) {
                String[] split = tagName.split(" ");
                return new Element(split[0]).attr("style", split[1]);
            }
            return new Element(tagName);
        }
        if (domPattern instanceof Function) {
            Function function = (Function)domPattern;
            return Helper.toElement(function.apply(isSingleline));
        }
        throw new UnknownException();
    }

    public static Element toElement(Object o) {
        if (o instanceof Element) {
            Element element = (Element)o;
            return element;
        }
        if (o instanceof String) {
            String tagName = (String)o;
            return new Element(tagName);
        }
        throw new UnknownException();
    }

    public static boolean maybeFlag(String flag) {
        String lowerCase = flag.toLowerCase();
        return FLAG_SYMBOL_TO_TAG.keySet().stream().anyMatch(s -> s.startsWith(lowerCase));
    }

    public static boolean isFlagReady(String flag) {
        String lowerCase = flag.toLowerCase();
        return FLAG_SYMBOL_TO_TAG.keySet().stream().anyMatch(s -> s.equals(lowerCase));
    }

    public static void flushToDom(StringBuilder sb, Element dom) {
        if (!sb.isEmpty()) {
            dom.appendText(Helper.clear(sb));
        }
    }

    public static String clear(StringBuilder sb) {
        String rt = sb.toString();
        sb.setLength(0);
        return rt;
    }

    public static ContentState checkStateAfterFinish(ContentState stateAfterFinish) {
        if (stateAfterFinish == null) {
            throw new NullValException("stateAfterFinish");
        }
        return stateAfterFinish;
    }

    public static void attr(Element dom, String attrName, Object val) {
        dom.attr(attrName, String.valueOf(val));
    }

    public static void css(Element dom, String cssName, Object val) {
        Helper.attr(dom, "style", cssName + ":" + val);
    }

    public static int calIndent(CharSequence s) {
        CharSequence withoutActivateChar = s.charAt(s.length() - 1) == '\\' ? s.subSequence(0, s.length() - 1) : s;
        int lastNewlineIndex = Helper.lastIndexOfNewline(withoutActivateChar);
        CharSequence lastLine = withoutActivateChar.subSequence(lastNewlineIndex, withoutActivateChar.length());
        int len = lastLine.length();
        int tabCount = 0;
        int spaceCount = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = lastLine.charAt(i);
            if (c == '\t') {
                ++tabCount;
                continue;
            }
            if (c == ' ') {
                ++spaceCount;
                continue;
            }
            return 0;
        }
        return tabCount + (spaceCount + 2) / 4;
    }

    public static int lastIndexOfNewline(CharSequence s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (!Helper.isNewline(c)) continue;
            return i + 1;
        }
        return 0;
    }

    static boolean isNewline(char c) {
        return c == '\n' || c == '\r';
    }

    static {
        FLAG_SYMBOL_TO_TAG.put("!", "b");
        FLAG_SYMBOL_TO_TAG.put("b", "b");
        FLAG_SYMBOL_TO_TAG.put("bold", "b");
        FLAG_SYMBOL_TO_TAG.put("/", "i");
        FLAG_SYMBOL_TO_TAG.put("i", "i");
        FLAG_SYMBOL_TO_TAG.put("italic", "i");
        FLAG_SYMBOL_TO_TAG.put("_", "u");
        FLAG_SYMBOL_TO_TAG.put("u", "u");
        FLAG_SYMBOL_TO_TAG.put("underline", "u");
        FLAG_SYMBOL_TO_TAG.put("-", "s");
        FLAG_SYMBOL_TO_TAG.put("s", "s");
        FLAG_SYMBOL_TO_TAG.put("strike", "s");
        FLAG_SYMBOL_TO_TAG.put("^", "sup");
        FLAG_SYMBOL_TO_TAG.put("sup", "sup");
        FLAG_SYMBOL_TO_TAG.put("v", "sub");
        FLAG_SYMBOL_TO_TAG.put("sub", "sub");
        FLAG_SYMBOL_TO_TAG.put(">", "code");
        FLAG_SYMBOL_TO_TAG.put("code", "code");
        FLAG_SYMBOL_TO_TAG.put("hide", "span display:none");
        FLAG_SYMBOL_TO_TAG.put("link", "a");
        FLAG_SYMBOL_TO_TAG.put("img", "img");
        FLAG_SYMBOL_TO_TAG.put("h1", "h1");
        FLAG_SYMBOL_TO_TAG.put("h2", "h2");
        FLAG_SYMBOL_TO_TAG.put("h3", "h3");
        FLAG_SYMBOL_TO_TAG.put("h4", "h4");
        FLAG_SYMBOL_TO_TAG.put("h5", "h5");
        FLAG_SYMBOL_TO_TAG.put("h6", "h6");
        Function<Boolean, String> q = isSingleline -> isSingleline != false ? "q" : "blockquote";
        FLAG_SYMBOL_TO_TAG.put("'", q);
        FLAG_SYMBOL_TO_TAG.put("\"", q);
        FLAG_SYMBOL_TO_TAG.put("q", q);
        FLAG_SYMBOL_TO_TAG.put("#", "ol");
        FLAG_SYMBOL_TO_TAG.put(".", "ul");
        FLAG_SYMBOL_TO_TAG.put("[", "table");
        FLAG_SYMBOL_TO_TAG.put("link", "a");
        FLAG_SYMBOL_TO_TAG.put("img", "img");
    }
}

