/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ActivateState;
import cool.document.qtmd.BaseMiddleState;
import cool.document.qtmd.ContentState;
import cool.document.qtmd.FormattingState;
import cool.document.qtmd.InFormattingActivateState;
import cool.document.qtmd.MiddleState;
import cool.document.qtmd.State;
import me.magicall.\u8d35\u9633DearSun.exception.UnknownException;
import org.jsoup.nodes.Element;

public class LiState
extends FormattingState {
    public final int indentCount;
    private final Element liParentDom;
    private Element curLiDom;
    private boolean isCurLiContentFinished;
    private boolean isCurLiSingleline;

    public LiState(ContentState stateAfterFinish, CharSequence flag, boolean isSingleline, int indentCount) {
        super(stateAfterFinish, flag, isSingleline);
        this.indentCount = indentCount;
        this.liParentDom = super.dom();
        this.newLi(isSingleline);
    }

    public final LiState newLi(boolean isCurLiSingleline) {
        this.curLiDom = this.liParentDom.appendElement("li");
        this.isCurLiContentFinished = false;
        this.isCurLiSingleline = isCurLiSingleline;
        return this;
    }

    @Override
    public Element dom() {
        return this.curLiDom;
    }

    @Override
    public boolean isSingleline() {
        return this.isCurLiSingleline;
    }

    @Override
    public State flushBuffer() {
        if (this.isCurLiContentFinished) {
            return this;
        }
        return super.flushBuffer();
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new InLiActivatingState(this, activateChar);
    }

    @Override
    public State metNewline(char newlineChar) {
        if (this.isCurLiSingleline) {
            this.curLiFinishContent();
            return new UnderLiState(this, newlineChar);
        }
        if (this.isCurLiContentFinished) {
            return new UnderLiState(this, newlineChar);
        }
        return super.metNewline(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return false;
    }

    public LiState curLiFinishContent() {
        this.flushBuffer();
        this.isCurLiContentFinished = true;
        return this;
    }

    public boolean isCurLiContentFinished() {
        return this.isCurLiContentFinished;
    }

    public static class InLiActivatingState
    extends InFormattingActivateState {
        private final LiState liState;

        public InLiActivatingState(LiState stateAfterFinish, char activateChar) {
            super(stateAfterFinish, activateChar);
            this.liState = stateAfterFinish;
        }

        @Override
        protected State finishFormatting(char c) {
            this.liState.curLiFinishContent();
            return new LiContentFinishedState(this.liState, c);
        }
    }

    public static class UnderLiState
    extends BaseMiddleState
    implements MaybeFollowingNextLiState {
        protected final char liContentFinishChar;

        public UnderLiState(LiState stateAfterFinish, char liContentFinishChar, CharSequence leadingChars, char newlineChar) {
            this(stateAfterFinish, liContentFinishChar);
            this.buffer.append(leadingChars).append(newlineChar);
        }

        public UnderLiState(LiState stateAfterFinish, char liContentFinishChar) {
            super(stateAfterFinish);
            this.liContentFinishChar = liContentFinishChar;
            stateAfterFinish.curLiFinishContent();
        }

        @Override
        public ActivateState metActivateChar(char activateChar) {
            return new UnderLiActivateState(this.liState(), this.buffer.toString() + activateChar, this.liContentFinishChar);
        }

        @Override
        public char liContentFinishChar() {
            return this.liContentFinishChar;
        }
    }

    public static class UnderLiActivateState
    extends ActivateState
    implements MaybeFollowingNextLiState {
        private final char liContentFinishChar;

        public UnderLiActivateState(LiState stateAfterFinish, Object activateChars, char liContentFinishChar) {
            super((ContentState)stateAfterFinish, activateChars);
            this.liContentFinishChar = liContentFinishChar;
        }

        @Override
        public boolean isFinishChar(char c) {
            return c != '#' && c != '.';
        }

        @Override
        public char liContentFinishChar() {
            return this.liContentFinishChar;
        }
    }

    public static class LiContentFinishedState
    extends BaseMiddleState
    implements MaybeFollowingNextLiState {
        private final char liContentFinishChar;

        public LiContentFinishedState(LiState liState, char liContentFinishChar) {
            super(liState);
            this.liContentFinishChar = liContentFinishChar;
            liState.curLiFinishContent();
        }

        @Override
        public char liContentFinishChar() {
            return this.liContentFinishChar;
        }

        @Override
        public State metNewline(char newlineChar) {
            return new UnderLiState(this.liState(), this.liContentFinishChar, this.buffer, newlineChar);
        }
    }

    public static interface MaybeFollowingNextLiState
    extends MiddleState {
        default public LiState liState() {
            ContentState stateAfterFinish = this.stateAfterFinish();
            if (stateAfterFinish instanceof LiState) {
                LiState liState = (LiState)stateAfterFinish;
                return liState;
            }
            if (stateAfterFinish instanceof MaybeFollowingNextLiState) {
                MaybeFollowingNextLiState maybeFollowingNextLiState = (MaybeFollowingNextLiState)((Object)stateAfterFinish);
                return maybeFollowingNextLiState.liState();
            }
            throw new UnknownException();
        }

        default public State finishLi(char c) {
            return this.liState().finish(this.liContentFinishChar()).metChars(this.buffer()).metChar(c);
        }

        public char liContentFinishChar();

        @Override
        default public State metActivateChar(char activateChar) {
            return this.finishLi(activateChar);
        }

        @Override
        default public State metNewline(char newlineChar) {
            return this.finishLi(newlineChar);
        }

        @Override
        default public State finish(char finishChar) {
            return this.finishLi(finishChar);
        }

        @Override
        default public State metOtherChar(char c) {
            if (Character.isWhitespace(c)) {
                return this.addChar(c);
            }
            return this.finishLi(c);
        }

        @Override
        default public State flushBuffer() {
            return this;
        }
    }
}

