/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class BaseMaybeFlagState extends BaseMiddleState implements MaybeFlagState {
	protected final CharSequence activateChars;//通常是\，可能前部带有空白字符。

	public BaseMaybeFlagState(final ContentState stateAfterFinish, final String flag, final CharSequence activateChars) {
		super(stateAfterFinish);
		setFlag0(flag);
		this.activateChars = activateChars;
	}

	private void setFlag0(final String flag) {
		clearBuffer();
		buffer().append(flag);
	}

	@Override
	public State metChar(final char c) {
		return super.metChar(c);
	}

	@Override
	public State finish(final char finishChar) {
		addActivateChars();
		return super.finish(finishChar);
	}

	@Override
	public void end() {
		addActivateChars();
		super.end();
	}

	private void addActivateChars() {
		buffer().insert(0, activateChars);
	}

	@Override
	public CharSequence activateChars() {
		return activateChars;
	}
}