/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public abstract class BaseMiddleState extends BaseState implements MiddleState {
	public BaseMiddleState(final ContentState stateAfterFinish) {
		super(Helper.checkStateAfterFinish(stateAfterFinish));
	}

	public BaseMiddleState(final ContentState stateAfterFinish, final StringBuilder initBuffer) {
		super(Helper.checkStateAfterFinish(stateAfterFinish), initBuffer);
	}

	public BaseMiddleState(final ContentState stateAfterFinish, final char curChar) {
		super(Helper.checkStateAfterFinish(stateAfterFinish), curChar);
	}

	public BaseMiddleState(final ContentState stateAfterFinish, final StringBuilder initBuffer, final char curChar) {
		super(Helper.checkStateAfterFinish(stateAfterFinish), initBuffer, curChar);
	}
}
