/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public abstract class BaseState implements State {
	protected final ContentState stateAfterFinish;
	protected final StringBuilder buffer;

	public BaseState(final ContentState stateAfterFinish) {
		this(stateAfterFinish, new StringBuilder());
	}

	public BaseState(final ContentState stateAfterFinish, final StringBuilder initBuffer) {
		this.stateAfterFinish = stateAfterFinish;
		buffer = new StringBuilder(initBuffer);
	}

	public BaseState(final ContentState stateAfterFinish, final char curChar) {
		this(stateAfterFinish);
		buffer.append(curChar);
	}

	public BaseState(final ContentState stateAfterFinish, final StringBuilder initBuffer, final char curChar) {
		this(stateAfterFinish, initBuffer);
		buffer.append(curChar);
	}

	@Override
	public ContentState stateAfterFinish() {
		return stateAfterFinish;
	}

	@Override
	public StringBuilder buffer() {
		return buffer;
	}
}
