/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class BgState extends BaseMaybeFlagState {
	public BgState(final ContentState stateAfterFinish, final String flag, final CharSequence activateChars) {
		super(stateAfterFinish, flag, activateChars);
	}

	@Override
	public boolean isFinishChar(final char c) {
		return !maybeColor(c) && super.isFinishChar(c);
	}

	@Override
	public State metOtherChar(final char c) {
		if (maybeColor(c)) {
			return new MaybeColorState(stateAfterFinish, buffer.toString() + c, activateChars);
		}
		return finish(c).metChar(c);
	}

	private static boolean maybeColor(final char c) {
		return c == '#';
	}
}
