/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class HashState extends MaybeColorState implements MaybeLiState {
	public HashState(final ContentState stateAfterFinish, final CharSequence activateChars, final char flagChar) {
		super(stateAfterFinish, String.valueOf(flagChar), activateChars);
	}

	@Override
	public State formatting(final char c, final boolean isSingleline) {
		if (Const.HASH_STR.contentEquals(buffer)) {//只有“#”，是有序列表
			return MaybeLiState.super.formatting(c, isSingleline);
		} else {//#xxx的可能是颜色。
			return super.formatting(c, isSingleline);
		}
	}
}
