/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class InFormattingActivateState extends ActivateState {
	public InFormattingActivateState(final FormattingState stateAfterFinish, final char activateChar) {
		super(stateAfterFinish, activateChar);
	}

	@Override
	public boolean isFinishChar(final char c) {
		final var formattingContentState = (FormattingState) stateAfterFinish;
		if (formattingContentState.isSingleline()) {
			if (isSinglelineEnd(c)) {
				return false;
			}
		} else {
			if (isMultilineEnd(c)) {
				return false;
			}
		}
		return super.isFinishChar(c);
	}

	@Override
	public State metOtherChar(final char c) {
		final var formattingContentState = (FormattingState) stateAfterFinish;
		if (formattingContentState.isSingleline() && isSinglelineEnd(c)) {
			return finishFormatting(c);
		} else if (!formattingContentState.isSingleline() && isMultilineEnd(c)) {
			return finishFormatting(c);
		}
		return super.metOtherChar(c);
	}

	protected State finishFormatting(final char c) {
		return stateAfterFinish.finish(c);
	}

	protected static boolean isSinglelineEnd(final char c) {
		return c == '|';
	}

	protected static boolean isMultilineEnd(final char c) {
		return c == ')';
	}
}
