/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

import java.util.Arrays;

public class MaybeColorState extends BaseMaybeFlagState {
	public MaybeColorState(final ContentState stateAfterFinish, final String flag, final CharSequence activateChars) {
		super(stateAfterFinish, flag, activateChars);
	}

	@Override
	public boolean isReady() {
		return super.isReady() || maybeColorFlag(buffer().toString());
	}

	@Override
	public boolean isFinishChar(final char c) {
		final var buffer = buffer().toString();
		return !Const.DEFAULT_OL_FLAG_STR.equals(buffer + c)//
				&& !maybeColorFlag(buffer)//
				&& !super.isFinishChar(c);
	}

	@Override
	public State formatting(final char c, final boolean isSingleline) {
		final var newDom = Helper.setCssColor(buffer().toString());
		if (newDom == null) {
			return finish(c);
		}
		final var afterFinish = stateAfterFinish();
		afterFinish.flushBuffer();
		newDom.appendTo(afterFinish.dom());
		return new FormattingState(afterFinish, newDom, isSingleline);
	}

	public static boolean maybeColorFlag(final String flag) {
		final var index = flag.indexOf('#');
		if (index == -1) {
			return false;
		}
		final var maybeColorStr = flag.substring(index + 1).toLowerCase();
		if (Helper.isHex(maybeColorStr)) {
			return true;
		}
		return Arrays.stream(Helper.NAMED_COLORS)//
				.anyMatch(namedColor -> namedColor.startsWith(maybeColorStr));
	}
}
