/*
 * Copyright (c) 2024 Document.Cool
 * QTMD is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public interface MaybeLiState extends MaybeFlagState {
	@Override
	default State formatting(final char c, final boolean isSingleline) {
		final var preState = stateAfterFinish();
		preState.flushBuffer();
		final var activateChars = activateChars();
		//前置状态：
		// 1，LiState
		// 	1.1，内容已结束的LiState。则本li可能是它的子级、同级、某个祖先节点的下级。
		// 	1.2，内容未结束的LiState，则本li确定是它的子级
		// 2，其他，说明之前不是li，则本li是它的子级。
		final int maybeMyIndent = Helper.calIndent(activateChars);
		ContentState s = preState;
		while (s instanceof final LiState p) {
			if (p.isCurLiContentFinished()) {
				final var thatIndent = p.indentCount;
				if (maybeMyIndent == thatIndent) {
					return p.newLi(isSingleline);
				} else if (maybeMyIndent > thatIndent) {
					return new LiState(p, buffer(), isSingleline, maybeMyIndent);
				} else {
					s = (ContentState) p.finish(c);
				}
			} else {
				break;
			}
		}
		//用前一个文本dom最后一行算缩进
		final var lastTextNode = s.dom().lastChild();
		final int realIndent;
		if (lastTextNode == null) {
			realIndent = maybeMyIndent;
		} else {
			realIndent = Helper.calIndent(lastTextNode.toString() + activateChars);
		}
		return new LiState(preState, buffer(), isSingleline, realIndent);
	}
}
