/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.BState;
import cool.document.qtmd.BaseMaybeFlagState;
import cool.document.qtmd.BaseMiddleState;
import cool.document.qtmd.ContentState;
import cool.document.qtmd.HashState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.IState;
import cool.document.qtmd.MaybeLiState;
import cool.document.qtmd.MaybeLinkState;
import cool.document.qtmd.MaybeUlState;
import cool.document.qtmd.State;
import cool.document.qtmd.TableState;

public class ActivateState
extends BaseMiddleState {
    public ActivateState(ContentState stateAfterFinish, Object activateChars) {
        super(stateAfterFinish);
        this.buffer.append(activateChars);
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new MultiEscapeState(this.stateAfterFinish, this.buffer);
    }

    @Override
    public State metNewline(char newlineChar) {
        return this.finish(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return !Helper.maybeFlag(String.valueOf(c));
    }

    @Override
    public State metOtherChar(char c) {
        return switch (c) {
            case '[' -> this.metLeftSquareBracket(c);
            case '#' -> this.metHash(c);
            case '.' -> this.metDot(c);
            case 'L', 'l' -> new MaybeLinkState(this.stateAfterFinish, c, (CharSequence)this.buffer);
            case 'I', 'i' -> new IState(this.stateAfterFinish, c, (CharSequence)this.buffer);
            case 'B', 'b' -> new BState(this.stateAfterFinish, c, (CharSequence)this.buffer);
            default -> new BaseMaybeFlagState(this.stateAfterFinish, String.valueOf(c), this.buffer);
        };
    }

    protected TableState metLeftSquareBracket(char c) {
        return new TableState(this.stateAfterFinish, c);
    }

    protected HashState metHash(char c) {
        return new HashState(this.stateAfterFinish, (CharSequence)this.buffer, c);
    }

    protected MaybeLiState metDot(char c) {
        return new MaybeUlState(this.stateAfterFinish, (CharSequence)this.buffer, c);
    }

    public static class MultiEscapeState
    extends BaseMiddleState {
        public MultiEscapeState(ContentState stateAfterFinish, StringBuilder initBuffer) {
            super(stateAfterFinish, initBuffer);
        }

        @Override
        public State metNewline(char newlineChar) {
            return this.finish(newlineChar);
        }

        @Override
        public State metActivateChar(char activateChar) {
            return this.addChar(activateChar);
        }

        @Override
        public boolean isFinishChar(char c) {
            return c != '\\';
        }
    }
}

