/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ActivateState;
import cool.document.qtmd.BaseState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.State;
import org.jsoup.nodes.Element;

public class ContentState
extends BaseState {
    private final Element dom;

    public ContentState(ContentState stateAfterFinish, Element dom) {
        super(stateAfterFinish);
        this.dom = dom;
    }

    @Override
    public ContentState stateAfterFinish() {
        return this.stateAfterFinish == null ? this : this.stateAfterFinish;
    }

    public Element dom() {
        return this.dom;
    }

    @Override
    public State metActivateChar(char activateChar) {
        return new ActivateState(this, Character.valueOf(activateChar));
    }

    @Override
    public State metNewline(char newlineChar) {
        this.checkHr();
        return super.metNewline(newlineChar);
    }

    @Override
    public void end() {
        this.checkHr();
        this.flushBuffer();
        ContentState stateAfterFinish = this.stateAfterFinish();
        if (stateAfterFinish != null && !this.equals(stateAfterFinish)) {
            stateAfterFinish.end();
        }
    }

    @Override
    public State flushBuffer() {
        Helper.flushToDom(this.buffer(), this.dom());
        return this;
    }

    protected boolean checkHr() {
        return Helper.canHaveHr(this.dom.tagName()) && ContentState.checkHr(this);
    }

    static boolean checkHr(ContentState state) {
        StringBuilder s = state.buffer();
        int index = s.lastIndexOf("\n");
        int afterLastNewlineIndex = index + 1;
        String lastLine = index == -1 ? s.toString() : s.substring(afterLastNewlineIndex);
        if (ContentState.countHyphens(lastLine) > 2) {
            s.delete(afterLastNewlineIndex, s.length());
            state.flushBuffer();
            state.dom().appendElement("hr");
            state.clearBuffer();
            return true;
        }
        return false;
    }

    static int countHyphens(CharSequence s) {
        int count = 0;
        int bound = s.length();
        for (int i = 0; i < bound; ++i) {
            char c = s.charAt(i);
            if (c == '-') {
                ++count;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return 0;
        }
        return count;
    }
}

