/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.FormattingState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.MiddleState;
import cool.document.qtmd.State;

public interface MaybeFlagState
extends MiddleState {
    @Override
    default public State metNewline(char newlineChar) {
        return this.finish(newlineChar);
    }

    @Override
    default public boolean isFinishChar(char c) {
        if (this.isReady() && (c == ':' || c == '(')) {
            return false;
        }
        return !Helper.maybeFlag(this.buffer().toString() + c);
    }

    @Override
    default public State metOtherChar(char c) {
        if (this.isReady()) {
            if (MaybeFlagState.isSinglelineChar(c)) {
                return this.formatting(c, true);
            }
            if (MaybeFlagState.isMultilineChar(c)) {
                return this.formatting(c, false);
            }
        }
        return MiddleState.super.metOtherChar(c);
    }

    default public State formatting(char c, boolean isSingleline) {
        return new FormattingState(this.stateAfterFinish(), (CharSequence)this.buffer(), isSingleline);
    }

    public CharSequence activateChars();

    default public boolean isReady() {
        return Helper.isFlagReady(this.buffer().toString());
    }

    public static boolean isSinglelineChar(char c) {
        return c == ':';
    }

    public static boolean isMultilineChar(char c) {
        return c == '(';
    }
}

