/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ContentState;
import cool.document.qtmd.FormattingState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.InFormattingActivateState;
import cool.document.qtmd.State;

public abstract class MultimediaState
extends FormattingState {
    private boolean isContentFinished;

    public MultimediaState(ContentState stateAfterFinish, CharSequence flag, boolean isSingleline) {
        super(stateAfterFinish, flag, isSingleline);
    }

    @Override
    public State metActivateChar(char activateChar) {
        if (this.isContentFinished) {
            return this.addChar(activateChar);
        }
        return new InMultimediaActivatingState(this, activateChar);
    }

    @Override
    public State metNewline(char newlineChar) {
        if (this.isSingleline() || this.isContentFinished) {
            return this.finish(newlineChar);
        }
        return super.metNewline(newlineChar);
    }

    @Override
    public boolean isFinishChar(char c) {
        return Character.isWhitespace(c) && (this.isSingleline() || this.isContentFinished);
    }

    @Override
    public State finish(char finishChar) {
        this.ensureAttrs();
        return super.finish(finishChar);
    }

    @Override
    protected State handleFinishChar(char finishChar) {
        if (Character.isWhitespace(finishChar)) {
            return this.stateAfterFinish().metChar(finishChar);
        }
        return this.stateAfterFinish();
    }

    @Override
    public void end() {
        this.ensureAttrs();
        super.end();
    }

    private void ensureAttrs() {
        if (this.isSingleline()) {
            this.singlelineSetAttrs();
        } else if (this.isContentFinished) {
            this.setUrl();
        } else {
            this.contentFinished();
        }
    }

    private MultimediaState contentFinished() {
        this.setContent();
        this.clearBuffer();
        this.isContentFinished = true;
        return this;
    }

    private void singlelineSetAttrs() {
        this.setContent();
        this.setUrl();
    }

    protected void setUrl() {
        Helper.attr(this.dom(), this.urlAttr(), this.url());
        this.clearBuffer();
    }

    protected abstract String urlAttr();

    protected CharSequence url() {
        return this.buffer;
    }

    protected void setContent() {
        this.dom().appendText(this.buffer.toString());
    }

    private static class InMultimediaActivatingState
    extends InFormattingActivateState {
        private final MultimediaState multimediaState;

        public InMultimediaActivatingState(MultimediaState multimediaState, char activateChar) {
            super(multimediaState, activateChar);
            this.multimediaState = multimediaState;
        }

        @Override
        public State metNewline(char newlineChar) {
            return super.metNewline(newlineChar);
        }

        @Override
        protected State finishFormatting(char c) {
            return this.multimediaState.isSingleline() ? this.multimediaState.finish(c) : this.multimediaState.contentFinished();
        }
    }

    public static class LinkState
    extends MultimediaState {
        public LinkState(ContentState stateAfterFinish, CharSequence flag, boolean isSingleline) {
            super(stateAfterFinish, flag, isSingleline);
        }

        @Override
        protected String urlAttr() {
            return "href";
        }

        @Override
        protected CharSequence url() {
            return Helper.isEmail(this.buffer) ? "mailto:" + this.buffer : this.buffer;
        }
    }

    public static class ImgState
    extends MultimediaState {
        public ImgState(ContentState stateAfterFinish, StringBuilder flag, boolean isSingleline) {
            super(stateAfterFinish, (CharSequence)flag, isSingleline);
        }

        @Override
        protected String urlAttr() {
            return "src";
        }

        @Override
        protected void setContent() {
            Helper.attr(this.dom(), "alt", this.buffer);
        }
    }
}

