/*
 * Decompiled with CFR 0.152.
 */
package cool.document.qtmd;

import cool.document.qtmd.ContentState;
import cool.document.qtmd.Helper;
import cool.document.qtmd.State;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class Qtmd {
    private static final String HTML_TEMPLATE = "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><title>QTMD\u9884\u89c8</title></head><body><div style=\"white-space:pre-wrap\"></div></body></html>";

    public static String toHtml(String content) {
        return Qtmd.toDom(content).html();
    }

    public static String toWrapperDomHtml(String content) {
        return Qtmd.toDom(content).outerHtml();
    }

    public static Document toDoc(String content) {
        return Qtmd.toDom(content).ownerDocument();
    }

    public static Element toDom(String content) {
        Document doc = Jsoup.parse((String)HTML_TEMPLATE);
        Helper.keepFormatting(doc);
        Element container = (Element)doc.select("div").get(0);
        String s = content.replace("\r\n", "\n").replace('\r', '\n');
        State finalState = new ContentState(null, container).metChars(s);
        finalState.end();
        return container;
    }
}

