/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.cipher.algorithm.util;

import cool.doudou.doudada.cipher.algorithm.enums.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.springframework.util.ObjectUtils;

public class DigestUtil {
    public static byte[] md5(String plaintext, String salt) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.MD5.code());
        if (!ObjectUtils.isEmpty((Object)salt)) {
            plaintext = (String)plaintext + salt;
        }
        messageDigest.update(((String)plaintext).getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    public static String md5Hex(String plaintext, String salt) throws Exception {
        byte[] bytes = DigestUtil.md5(plaintext, salt);
        StringBuilder sbHex = new StringBuilder();
        for (byte b : bytes) {
            String bHex = Integer.toHexString(b & 0xFF);
            if (bHex.length() < 2) {
                sbHex.append(0);
            }
            sbHex.append(bHex);
        }
        return sbHex.toString();
    }

    public static byte[] sha1(String plaintext, String salt) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SHA1.code());
        if (!ObjectUtils.isEmpty((Object)salt)) {
            plaintext = (String)plaintext + salt;
        }
        messageDigest.update(((String)plaintext).getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    public static String sha1Hex(String plaintext, String salt) throws Exception {
        byte[] bytes = DigestUtil.sha1(plaintext, salt);
        StringBuilder sbHex = new StringBuilder();
        for (byte b : bytes) {
            String bHex = Integer.toHexString(b & 0xFF);
            if (bHex.length() < 2) {
                sbHex.append(0);
            }
            sbHex.append(bHex);
        }
        return sbHex.toString();
    }

    public static byte[] sha256(String plaintext, String salt) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SHA256.code());
        if (!ObjectUtils.isEmpty((Object)salt)) {
            plaintext = (String)plaintext + salt;
        }
        messageDigest.update(((String)plaintext).getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    public static String sha256Hex(String plaintext, String salt) throws Exception {
        byte[] bytes = DigestUtil.sha256(plaintext, salt);
        StringBuilder sbHex = new StringBuilder();
        for (byte b : bytes) {
            String bHex = Integer.toHexString(b & 0xFF);
            if (bHex.length() < 2) {
                sbHex.append(0);
            }
            sbHex.append(bHex);
        }
        return sbHex.toString();
    }
}

