package cool.doudou.doudada.message.core.api;

import com.alibaba.fastjson2.JSONObject;
import cool.doudou.doudada.message.core.util.HttpUtil;
import org.springframework.util.ObjectUtils;

import java.util.Map;

/**
 * WxApi
 *
 * @author jiangcs
 * @since 2022/08/23
 */
public class WxApi {
    /**
     * 发送 模板消息
     *
     * @param urlParam Url参数
     * @param jsonStr  模版消息字符串
     * @return 结果
     */
    public JSONObject template(Map<String, String> urlParam, String jsonStr) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send";
        String result = HttpUtil.doPost(url, urlParam, jsonStr);
        if (!ObjectUtils.isEmpty(result)) {
            return JSONObject.parseObject(result, JSONObject.class);
        }
        throw new RuntimeException("调用微信接口[cgi-bin/message/template/send]失败：result is empty");
    }
}
