package cool.doudou.doudada.message.core.util;

import cool.doudou.doudada.message.core.factory.OkHttpFactory;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.springframework.util.ObjectUtils;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * HttpUtil
 *
 * @author jiangcs
 * @since 2022/06/30
 */
@Slf4j
public class HttpUtil {
    private static final OkHttpClient okHttpClient;

    static {
        okHttpClient = OkHttpFactory.get();
    }

    /**
     * get 请求
     *
     * @param url      请求Url
     * @param urlParam Url参数
     * @return 结果
     */
    public static String doGet(String url, Map<String, String> urlParam) {
        // Query
        StringBuilder sbUrlParam = new StringBuilder();
        if (urlParam != null && urlParam.keySet().size() > 0) {
            for (String key : urlParam.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(URLEncoder.encode(urlParam.get(key), StandardCharsets.UTF_8));
            }
        }
        url += sbUrlParam;

        Request request = new Request.Builder().url(url).build();

        log.info("url => GET {}", url);
        log.info("urlParam => {}", urlParam);

        return execute(request);
    }

    /**
     * Post 请求
     *
     * @param url       请求Url
     * @param urlParam  Url参数
     * @param bodyParam Body参数
     * @return 结果
     */
    public static String doPost(String url, Map<String, String> urlParam, String bodyParam) {
        Request.Builder builder = new Request.Builder();
        // Query
        StringBuilder sbUrlParam = new StringBuilder();
        if (urlParam != null && urlParam.keySet().size() > 0) {
            for (String key : urlParam.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(urlParam.get(key));
            }
        }
        url += sbUrlParam;
        // Body
        if (bodyParam == null) {
            bodyParam = "";
        }
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), bodyParam);
        Request request = builder.url(url).post(requestBody).build();

        log.info("url => POST {}", url);
        log.info("urlParam => {}", urlParam);
        log.info("body => {}", bodyParam);

        return execute(request);
    }

    private static String execute(Request request) {
        try (Response response = okHttpClient.newCall(request).execute()) {
            if (response.isSuccessful()) {
                ResponseBody responseBody = response.body();
                if (!ObjectUtils.isEmpty(responseBody)) {
                    String result = responseBody.string();
                    log.info("execute => success: {}", result);
                    return result;
                }
            }
            log.error("execute => fail: {}", response);
        } catch (Exception e) {
            log.error("execute => exception: ", e);
        }
        return null;
    }
}
