/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.message.core.helper;

import com.alibaba.fastjson2.JSONObject;
import cool.doudou.doudada.message.core.api.AliApi;
import cool.doudou.doudada.message.core.api.WxApi;
import cool.doudou.doudada.message.core.util.DateUtil;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    private AliApi aliApi;
    private WxApi wxApi;

    public String aliSms(String phoneNumbers, String signName, String templateCode, String templateParam, String outId) {
        JSONObject resultObj;
        if (this.aliApi == null) {
            throw new IllegalArgumentException("\u963f\u91cc\u4e91\u6d88\u606f\u914d\u7f6e\u9519\u8bef");
        }
        HashMap<String, String> bizParamMap = new HashMap<String, String>(4);
        bizParamMap.put("PhoneNumbers", phoneNumbers);
        bizParamMap.put("SignName", signName);
        bizParamMap.put("TemplateCode", templateCode);
        bizParamMap.put("TemplateParam", templateParam);
        if (!ObjectUtils.isEmpty((Object)outId)) {
            bizParamMap.put("OutId", outId);
        }
        if (!ObjectUtils.isEmpty((Object)(resultObj = this.aliApi.sms("SendSms", bizParamMap)))) {
            if ("OK".equals(resultObj.getString("Code"))) {
                log.info("Sms\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a" + resultObj.getString("BizId"));
                return resultObj.getString("BizId");
            }
            log.error("Sms\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + resultObj.getString("Message"));
        } else {
            log.error("Sms\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return null;
    }

    public String aliSmsQuery(String phoneNumber, String bizId, String sendDate) {
        if (this.aliApi == null) {
            throw new IllegalArgumentException("\u963f\u91cc\u4e91\u6d88\u606f\u914d\u7f6e\u9519\u8bef");
        }
        HashMap<String, String> bizParamMap = new HashMap<String, String>(5);
        bizParamMap.put("PhoneNumber", phoneNumber);
        bizParamMap.put("BizId", bizId);
        bizParamMap.put("SendDate", sendDate == null ? DateUtil.formatDate(new Date(), "yyyyMMdd") : sendDate);
        bizParamMap.put("PageSize", "50");
        bizParamMap.put("CurrentPage", "1");
        JSONObject resultObj = this.aliApi.sms("QuerySendDetails", bizParamMap);
        if (!ObjectUtils.isEmpty((Object)resultObj)) {
            if ("OK".equals(resultObj.getString("Code"))) {
                log.info("Sms\u6d88\u606f\u67e5\u8be2\u6210\u529f\uff1a" + resultObj.getString("SmsSendDetailDTOs"));
                return resultObj.getString("SmsSendDetailDTOs");
            }
            log.error("Sms\u6d88\u606f\u67e5\u8be2\u5931\u8d25\uff1a" + resultObj.getString("Message"));
        } else {
            log.error("Sms\u6d88\u606f\u67e5\u8be2\u5931\u8d25\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return null;
    }

    public String aliVoice(String calledNumber, String ttsCode, String ttsParam, String outId) {
        return this.aliVoice(calledNumber, ttsCode, ttsParam, null, null, null, outId);
    }

    public String aliVoice(String calledNumber, String ttsCode, String ttsParam, Integer speed, String outId) {
        return this.aliVoice(calledNumber, ttsCode, ttsParam, null, null, speed, outId);
    }

    public String aliVoice(String calledNumber, String ttsCode, String ttsParam, Integer playTimes, Integer speed, String outId) {
        return this.aliVoice(calledNumber, ttsCode, ttsParam, playTimes, null, speed, outId);
    }

    public String aliVoice(String calledNumber, String ttsCode, String ttsParam, Integer playTimes, Integer volume, Integer speed, String outId) {
        JSONObject resultObj;
        if (this.aliApi == null) {
            throw new IllegalArgumentException("\u963f\u91cc\u4e91\u6d88\u606f\u914d\u7f6e\u9519\u8bef");
        }
        HashMap<String, String> bizParamMap = new HashMap<String, String>(4);
        bizParamMap.put("CalledNumber", calledNumber);
        bizParamMap.put("TtsCode", ttsCode);
        bizParamMap.put("TtsParam", ttsParam);
        if (!ObjectUtils.isEmpty((Object)playTimes)) {
            bizParamMap.put("PlayTimes", String.valueOf(playTimes));
        }
        if (!ObjectUtils.isEmpty((Object)volume)) {
            bizParamMap.put("Volume", String.valueOf(volume));
        }
        if (!ObjectUtils.isEmpty((Object)speed)) {
            bizParamMap.put("Speed", String.valueOf(speed));
        }
        if (!ObjectUtils.isEmpty((Object)outId)) {
            bizParamMap.put("OutId", outId);
        }
        if (!ObjectUtils.isEmpty((Object)(resultObj = this.aliApi.voice("SingleCallByTts", bizParamMap)))) {
            if ("OK".equals(resultObj.getString("Code"))) {
                log.info("Voice\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a" + resultObj.getString("CallId"));
                return resultObj.getString("CallId");
            }
            log.error("Voice\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + resultObj.getString("Message"));
        } else {
            log.error("Voice\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return null;
    }

    public String aliVoiceQuery(String callId) {
        if (this.aliApi == null) {
            throw new IllegalArgumentException("\u963f\u91cc\u4e91\u6d88\u606f\u914d\u7f6e\u9519\u8bef");
        }
        HashMap<String, String> bizParamMap = new HashMap<String, String>(4);
        bizParamMap.put("CallId", callId);
        bizParamMap.put("ProdId", "11000000300006");
        bizParamMap.put("QueryDate", String.valueOf(System.currentTimeMillis()));
        JSONObject resultObj = this.aliApi.voice("QueryCallDetailByCallId", bizParamMap);
        if (!ObjectUtils.isEmpty((Object)resultObj)) {
            if ("OK".equals(resultObj.getString("Code"))) {
                log.info("Voice\u6d88\u606f\u67e5\u8be2\u7ed3\u679c\uff1a" + resultObj.getString("Data"));
                return resultObj.getString("Data");
            }
            log.error("Voice\u6d88\u606f\u67e5\u8be2\u5931\u8d25\uff1a" + resultObj.getString("Message"));
        } else {
            log.error("Voice\u6d88\u606f\u67e5\u8be2\u5931\u8d25\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return null;
    }

    public boolean wxTemplateMsg(String accessToken, String openId, String templateId, String templateData) {
        if (this.wxApi == null) {
            throw new IllegalArgumentException("\u5fae\u4fe1\u6d88\u606f\u914d\u7f6e\u9519\u8bef");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"touser", (Object)openId);
        jsonObject.put((Object)"template_id", (Object)templateId);
        jsonObject.put((Object)"data", JSONObject.parseObject((String)templateData, JSONObject.class));
        HashMap<String, String> urlParam = new HashMap<String, String>(1);
        urlParam.put("access_token", accessToken);
        JSONObject resultObj = this.wxApi.template(urlParam, jsonObject.toString());
        if (!ObjectUtils.isEmpty((Object)resultObj)) {
            if (0 == resultObj.getIntValue("errcode")) {
                log.info("\u6a21\u677f\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a{}", (Object)jsonObject);
                return true;
            }
            log.error("\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + resultObj.getString("errmsg"));
        } else {
            log.error("\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return false;
    }

    @Autowired(required=false)
    public void setAliApi(AliApi aliApi) {
        this.aliApi = aliApi;
    }

    @Autowired(required=false)
    public void setWxApi(WxApi wxApi) {
        this.wxApi = wxApi;
    }
}

