/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.message.core.signer;

import cool.doudou.doudada.cipher.algorithm.util.HmacUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AliSigner {
    public static String get(String accessSecret, String method, Map<String, String> urlParam) {
        TreeMap<String, String> paramMap = new TreeMap<String, String>(urlParam);
        ArrayList<String> keyList = new ArrayList<String>(paramMap.keySet());
        Collections.sort(keyList);
        String queryString = AliSigner.constructQueryString(keyList, paramMap);
        return AliSigner.computeSignatureValue(accessSecret, method, queryString);
    }

    private static String constructQueryString(List<String> keyList, Map<String, String> paramMap) {
        StringBuilder sbSignatureValue = new StringBuilder();
        for (String key : keyList) {
            if (sbSignatureValue.length() > 0) {
                sbSignatureValue.append("&");
            }
            sbSignatureValue.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(paramMap.get(key), StandardCharsets.UTF_8));
        }
        return sbSignatureValue.toString();
    }

    private static String computeSignatureValue(String accessSecret, String method, String queryString) {
        String signString = method + "&" + URLEncoder.encode("/", StandardCharsets.UTF_8) + "&" + URLEncoder.encode(queryString, StandardCharsets.UTF_8);
        return HmacUtil.sha1((String)(accessSecret + "&"), (String)signString);
    }
}

