/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.message.core.util;

import cool.doudou.doudada.message.core.factory.OkHttpFactory;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final OkHttpClient okHttpClient = OkHttpFactory.get();

    public static String doGet(String url, Map<String, String> urlParam) {
        StringBuilder sbUrlParam = new StringBuilder();
        if (urlParam != null && urlParam.keySet().size() > 0) {
            for (String key : urlParam.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(URLEncoder.encode(urlParam.get(key), StandardCharsets.UTF_8));
            }
        }
        url = (String)url + sbUrlParam;
        Request request = new Request.Builder().url((String)url).build();
        log.info("url => GET {}", url);
        log.info("urlParam => {}", urlParam);
        return HttpUtil.execute(request);
    }

    public static String doPost(String url, Map<String, String> urlParam, String bodyParam) {
        Request.Builder builder = new Request.Builder();
        StringBuilder sbUrlParam = new StringBuilder();
        if (urlParam != null && urlParam.keySet().size() > 0) {
            for (String key : urlParam.keySet()) {
                if (sbUrlParam.length() <= 0) {
                    sbUrlParam.append("?");
                } else {
                    sbUrlParam.append("&");
                }
                sbUrlParam.append(key).append("=").append(urlParam.get(key));
            }
        }
        url = (String)url + sbUrlParam;
        if (bodyParam == null) {
            bodyParam = "";
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)bodyParam);
        Request request = builder.url((String)url).post(requestBody).build();
        log.info("url => POST {}", url);
        log.info("urlParam => {}", urlParam);
        log.info("body => {}", (Object)bodyParam);
        return HttpUtil.execute(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String execute(Request request) {
        try (Response response = okHttpClient.newCall(request).execute();){
            ResponseBody responseBody;
            if (response.isSuccessful() && !ObjectUtils.isEmpty((Object)(responseBody = response.body()))) {
                String result = responseBody.string();
                log.info("execute => success: {}", (Object)result);
                String string = result;
                return string;
            }
            log.error("execute => fail: {}", (Object)response);
            return null;
        }
        catch (Exception e) {
            log.error("execute => exception: ", (Throwable)e);
        }
        return null;
    }
}

