package cool.doudou.doudada.message.auto.configuration;

import cool.doudou.doudada.message.config.MessageConfig;
import cool.doudou.doudada.message.core.helper.MessageHelper;
import cool.doudou.doudada.message.properties.AliProperties;
import cool.doudou.doudada.message.properties.WxProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * MessageAutoConfiguration
 *
 * @author jiangcs
 * @since 2022/08/25
 */
@EnableConfigurationProperties({AliProperties.class, WxProperties.class})
@Import({MessageConfig.class})
@AutoConfiguration
public class MessageAutoConfiguration {
    @ConditionalOnMissingBean(MessageHelper.class)
    @Bean
    public MessageHelper messageHelper() {
        return new MessageHelper();
    }
}
