package cool.doudou.doudada.message.core.api;

import com.alibaba.fastjson2.JSONObject;
import cool.doudou.doudada.message.core.signer.AliSigner;
import cool.doudou.doudada.message.core.util.DateUtil;
import cool.doudou.doudada.message.core.util.HttpUtil;
import cool.doudou.doudada.message.properties.AliProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * AliApi
 *
 * @author jiangcs
 * @since 2022/08/23
 */
public class AliApi {
    private AliProperties aliProperties;

    /**
     * 发送 短信消息
     *
     * @param action      操作
     * @param bizParamMap 业务参数
     * @return 结果
     */
    public JSONObject sms(String action, Map<String, String> bizParamMap) {
        String url = "https://dysmsapi.aliyuncs.com/";

        Map<String, String> urlParam = new HashMap<>(8);
        urlParam.put("Action", action);
        urlParam.put("Version", "2017-05-25");
        urlParam.put("Format", "JSON");
        urlParam.put("AccessKeyId", aliProperties.getAccessKeyId());
        urlParam.put("SignatureNonce", UUID.randomUUID().toString().replaceAll("-", ""));
        urlParam.put("Timestamp", DateUtil.formatDate(new Date(), "yyyy-MM-dd'T'HH:mm:ss'Z'", TimeZone.getTimeZone("GMT")));
        urlParam.put("SignatureMethod", "HMAC-SHA1");
        urlParam.put("SignatureVersion", "1.0");

        // 业务参数
        if (bizParamMap != null) {
            urlParam.putAll(bizParamMap);
        }

        // 签名
        urlParam.put("Signature", AliSigner.get(aliProperties.getAccessSecret(), "GET", urlParam));

        String result = HttpUtil.doGet(url, urlParam);
        if (!ObjectUtils.isEmpty(result)) {
            return JSONObject.parseObject(result, JSONObject.class);
        }
        throw new RuntimeException("调用阿里云接口[" + action + "]失败：result is empty");
    }

    /**
     * 发送 语音消息
     *
     * @param action      操作
     * @param bizParamMap 业务参数
     * @return 结果
     */
    public JSONObject voice(String action, Map<String, String> bizParamMap) {
        String url = "https://dyvmsapi.aliyuncs.com";

        Map<String, String> urlParam = new HashMap<>(8);
        urlParam.put("Action", action);
        urlParam.put("Version", "2017-05-25");
        urlParam.put("Format", "JSON");
        urlParam.put("AccessKeyId", aliProperties.getAccessKeyId());
        urlParam.put("SignatureNonce", UUID.randomUUID().toString().replaceAll("-", ""));
        urlParam.put("Timestamp", DateUtil.formatDate(new Date(), "yyyy-MM-dd'T'HH:mm:ss'Z'", TimeZone.getTimeZone("GMT")));
        urlParam.put("SignatureMethod", "HMAC-SHA1");
        urlParam.put("SignatureVersion", "1.0");

        // 业务参数
        if (bizParamMap != null) {
            urlParam.putAll(bizParamMap);
        }

        // 签名
        urlParam.put("Signature", AliSigner.get(aliProperties.getAccessSecret(), "GET", urlParam));

        String result = HttpUtil.doGet(url, urlParam);
        if (!ObjectUtils.isEmpty(result)) {
            return JSONObject.parseObject(result, JSONObject.class);
        }
        throw new RuntimeException("调用阿里云接口[" + action + "]失败：result is empty");
    }

    @Autowired
    public void setAliProperties(AliProperties aliProperties) {
        this.aliProperties = aliProperties;
    }
}
