package cool.doudou.doudada.message.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * DateUtil
 *
 * @author jiangcs
 * @since 2022/08/24
 */
public class DateUtil {
    /**
     * 日期格式化
     *
     * @param date    日期
     * @param pattern 日期格式
     * @return 日期字符串
     */
    public static String formatDate(Date date, String pattern) {
        return formatDate(date, pattern, TimeZone.getDefault());
    }

    /**
     * 日期格式化
     *
     * @param date     日期
     * @param pattern  日期格式
     * @param timeZone 时区
     * @return 日期字符串
     */
    public static String formatDate(Date date, String pattern, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(timeZone);
        return sdf.format(date);
    }
}
