package cool.doudou.doudada.mq.core.factory;

import org.apache.pulsar.client.api.Producer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * ProducerMapFactory
 *
 * @author jiangcs
 * @since 2022/2/19
 */
public class ProducerMapFactory {
    private static final Map<String, Producer<String>> map = new ConcurrentHashMap<>();

    public static Producer<String> get(String topic) {
        return map.get(topic);
    }

    public static void add(String topic, Producer<String> producer) {
        map.put(topic, producer);
    }
}
