package cool.doudou.doudada.mq.core.enums;

import org.apache.pulsar.client.api.Schema;

/**
 * MsgTypeEnum
 *
 * @author jiangcs
 * @since 2023/01/06
 */
public enum MsgTypeEnum {
    STRING(Schema.STRING),
    BYTES(Schema.BYTES),
    INT8(Schema.INT8),
    INT16(Schema.INT16),
    INT32(Schema.INT32),
    INT64(Schema.INT64),
    FLOAT(Schema.FLOAT),
    DOUBLE(Schema.DOUBLE),
    BOOL(Schema.BOOL);

    private final Schema<?> schema;

    MsgTypeEnum(Schema<?> schema) {
        this.schema = schema;
    }

    public Schema<?> get() {
        return this.schema;
    }
}
