/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.mq.core.helper;

import cool.doudou.doudada.mq.core.factory.ProducerMapFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqHelper {
    private static final Logger log = LoggerFactory.getLogger(MqHelper.class);

    public String send(String topic, String msg) {
        try {
            Producer<String> producer = ProducerMapFactory.get(topic);
            if (producer != null) {
                return producer.send((Object)msg).toString();
            }
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
        }
        return null;
    }

    public String send(String topic, String key, String msg) {
        try {
            Producer<String> producer = ProducerMapFactory.get(topic);
            if (producer != null) {
                return producer.newMessage().key(key).value((Object)msg).send().toString();
            }
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
        }
        return null;
    }

    public String send(String topic, String msg, long delay) {
        try {
            Producer<String> producer = ProducerMapFactory.get(topic);
            if (producer != null) {
                return producer.newMessage().value((Object)msg).deliverAfter(delay, TimeUnit.MILLISECONDS).send().toString();
            }
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
        }
        return null;
    }

    public String send(String topic, String key, String msg, long delay) {
        try {
            Producer<String> producer = ProducerMapFactory.get(topic);
            if (producer != null) {
                return producer.newMessage().key(key).value((Object)msg).deliverAfter(delay, TimeUnit.MILLISECONDS).send().toString();
            }
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
        }
        return null;
    }

    public void sendAsync(String topic, String msg, Consumer<String> action) {
        Producer<String> producer = ProducerMapFactory.get(topic);
        if (producer != null) {
            CompletionStage completableFuture = producer.sendAsync((Object)msg).exceptionally(e -> {
                log.error("sendAsync exception: ", e);
                return null;
            });
            if (action != null) {
                ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
            }
        }
    }

    public void sendAsync(String topic, String key, String msg, Consumer<String> action) {
        Producer<String> producer = ProducerMapFactory.get(topic);
        if (producer != null) {
            CompletionStage completableFuture = producer.newMessage().key(key).value((Object)msg).sendAsync().exceptionally(e -> {
                log.error("sendAsync exception: ", e);
                return null;
            });
            if (action != null) {
                ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
            }
        }
    }

    public void sendAsync(String topic, String msg, long delay, Consumer<String> action) {
        Producer<String> producer = ProducerMapFactory.get(topic);
        if (producer != null) {
            CompletionStage completableFuture = producer.newMessage().value((Object)msg).deliverAfter(delay, TimeUnit.MILLISECONDS).sendAsync().exceptionally(e -> {
                log.error("sendAsync exception: ", e);
                return null;
            });
            if (action != null) {
                ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
            }
        }
    }

    public void sendAsync(String topic, String key, String msg, long delay, Consumer<String> action) {
        Producer<String> producer = ProducerMapFactory.get(topic);
        if (producer != null) {
            CompletionStage completableFuture = producer.newMessage().key(key).value((Object)msg).deliverAfter(delay, TimeUnit.MILLISECONDS).sendAsync().exceptionally(e -> {
                log.error("sendAsync exception: ", e);
                return null;
            });
            if (action != null) {
                ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
            }
        }
    }
}

