/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import cool.doudou.doudada.oss.properties.GridFsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"oss.storage-mode"}, havingValue="gridFs")
public class GridFsConfig {
    private GridFsProperties gridFsProperties;

    @Bean
    public MongoClient mongoClient() {
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.gridFsProperties.getServerUri() + "/" + this.gridFsProperties.getDatabase())).build();
        return MongoClients.create((MongoClientSettings)settings);
    }

    @Bean
    public GridFSBucket gridFsBucket(MongoClient mongoClient) {
        return GridFSBuckets.create((MongoDatabase)mongoClient.getDatabase(this.gridFsProperties.getDatabase()), (String)this.gridFsProperties.getBucketName());
    }

    public GridFsConfig(GridFsProperties gridFsProperties) {
        this.gridFsProperties = gridFsProperties;
    }
}

