/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.core.helper;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import cool.doudou.doudada.oss.core.helper.OssHelper;
import cool.doudou.doudada.oss.core.rs.OssResult;
import cool.doudou.doudada.oss.core.util.FileUtil;
import cool.doudou.doudada.oss.core.util.IoUtil;
import cool.doudou.doudada.oss.properties.AliYunProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.multipart.MultipartFile;

@ConditionalOnProperty(name={"file.storage-mode"}, havingValue="aliYun")
public class AliYunHelper
implements OssHelper {
    private static final Logger log = LoggerFactory.getLogger(AliYunHelper.class);
    private AliYunProperties aliYunProperties;
    private OSSClient ossClient;

    @Override
    public OssResult upload(MultipartFile multipartFile) {
        return this.upload(multipartFile, "default");
    }

    @Override
    public OssResult upload(File file) {
        return this.upload(file, "default");
    }

    @Override
    public OssResult upload(MultipartFile multipartFile, String category) {
        if (multipartFile == null) {
            throw new RuntimeException("\u6587\u4ef6\u5f02\u5e38");
        }
        String filename = multipartFile.getOriginalFilename();
        if (filename == null) {
            throw new RuntimeException("\u6587\u4ef6\u540d\u79f0\u5f02\u5e38");
        }
        try {
            String key = FileUtil.getFileKey(filename, true);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.addUserMetadata("category", category);
            this.ossClient.putObject(this.aliYunProperties.getBucketName(), key, multipartFile.getInputStream(), objectMetadata);
            return OssResult.ok(key, filename, multipartFile.getContentType());
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ", e);
        }
    }

    @Override
    public OssResult upload(File file, String category) {
        MultipartFile multipartFile;
        try {
            multipartFile = FileUtil.file2MultipartFile(file);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u5f02\u5e38");
        }
        return this.upload(multipartFile, category);
    }

    @Override
    public void download(String key, HttpServletResponse response) {
        this.download(key, "default", response);
    }

    @Override
    public void download(String key, String category, HttpServletResponse response) {
        try {
            OSSObject ossObject = this.ossClient.getObject(this.aliYunProperties.getBucketName(), key);
            IoUtil.setContentDisposition4Download(response, key);
            IoUtil.write(ossObject.getObjectContent(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 ", e);
        }
    }

    @Override
    public void preview(String key, HttpServletResponse response) {
        this.preview(key, "default", response);
    }

    @Override
    public void preview(String key, String category, HttpServletResponse response) {
        try {
            OSSObject ossObject = this.ossClient.getObject(this.aliYunProperties.getBucketName(), key);
            IoUtil.setContentDisposition4Preview(response, key);
            IoUtil.write(ossObject.getObjectContent(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u9884\u89c8\u5f02\u5e38 ", e);
        }
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, "default");
    }

    @Override
    public boolean delete(String key, String category) {
        try {
            this.ossClient.deleteObject(this.aliYunProperties.getBucketName(), key);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5220\u9664\u5f02\u5e38 ", e);
        }
    }

    @Autowired
    public void setAliYunProperties(AliYunProperties aliYunProperties) {
        this.aliYunProperties = aliYunProperties;
    }

    @Autowired
    public void setOssClient(OSSClient ossClient) {
        this.ossClient = ossClient;
    }
}

