/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.doudada.oss.core.helper;

import cool.doudou.doudada.oss.core.helper.OssHelper;
import cool.doudou.doudada.oss.core.rs.OssResult;
import cool.doudou.doudada.oss.core.util.FileUtil;
import cool.doudou.doudada.oss.core.util.IoUtil;
import cool.doudou.doudada.oss.properties.MinIoProperties;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.multipart.MultipartFile;

@ConditionalOnProperty(name={"oss.storage-mode"}, havingValue="minIO")
public class MinIOHelper
implements OssHelper {
    private static final Logger log = LoggerFactory.getLogger(MinIOHelper.class);
    private MinIoProperties minIoProperties;
    private MinioClient minioClient;

    @Override
    public OssResult upload(MultipartFile multipartFile) {
        return this.upload(multipartFile, "default");
    }

    @Override
    public OssResult upload(File file) {
        return this.upload(file, "default");
    }

    @Override
    public OssResult upload(MultipartFile multipartFile, String category) {
        if (multipartFile == null) {
            throw new RuntimeException("\u6587\u4ef6\u5f02\u5e38");
        }
        String filename = multipartFile.getOriginalFilename();
        if (filename == null) {
            throw new RuntimeException("\u6587\u4ef6\u540d\u79f0\u5f02\u5e38");
        }
        try {
            String key = FileUtil.getFileKey(filename, true);
            HashMap<String, String> userMetadata = new HashMap<String, String>(1);
            userMetadata.put("category", category);
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minIoProperties.getBucketName())).object(key)).stream(multipartFile.getInputStream(), multipartFile.getSize(), -1L).contentType(multipartFile.getContentType()).userMetadata(userMetadata)).build();
            this.minioClient.putObject(objectArgs);
            return OssResult.ok(key, filename, multipartFile.getContentType());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ", e);
        }
    }

    @Override
    public OssResult upload(File file, String category) {
        MultipartFile multipartFile;
        try {
            multipartFile = FileUtil.file2MultipartFile(file);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8f6c\u6362\u5f02\u5e38");
        }
        return this.upload(multipartFile, category);
    }

    @Override
    public void download(String key, HttpServletResponse response) {
        this.download(key, "default", response);
    }

    @Override
    public void download(String key, String category, HttpServletResponse response) {
        try {
            GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minIoProperties.getBucketName())).object(key)).build();
            GetObjectResponse getObjectResponse = this.minioClient.getObject(objectArgs);
            IoUtil.setContentDisposition4Download(response, key);
            IoUtil.write(new ByteArrayInputStream(getObjectResponse.readAllBytes()), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 ", e);
        }
    }

    @Override
    public void preview(String key, HttpServletResponse response) {
        this.preview(key, "default", response);
    }

    @Override
    public void preview(String key, String category, HttpServletResponse response) {
        try {
            GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minIoProperties.getBucketName())).object(key)).build();
            GetObjectResponse getObjectResponse = this.minioClient.getObject(objectArgs);
            IoUtil.setContentDisposition4Preview(response, key);
            IoUtil.write(new ByteArrayInputStream(getObjectResponse.readAllBytes()), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u9884\u89c8\u5f02\u5e38 ", e);
        }
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, "default");
    }

    @Override
    public boolean delete(String key, String category) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.minIoProperties.getBucketName())).object(key)).build());
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u5220\u9664\u5f02\u5e38 ", e);
        }
    }

    @Autowired
    public void setMinIoProperties(MinIoProperties minIoProperties) {
        this.minIoProperties = minIoProperties;
    }

    @Autowired
    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }
}

