package cool.doudou.doudada.oss.auto.configuration;

import cool.doudou.doudada.oss.config.AliYunConfig;
import cool.doudou.doudada.oss.config.GridFsConfig;
import cool.doudou.doudada.oss.config.MinIOConfig;
import cool.doudou.doudada.oss.core.enums.StorageMode;
import cool.doudou.doudada.oss.core.helper.*;
import cool.doudou.doudada.oss.properties.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * OssAutoConfiguration
 *
 * @author jiangcs
 * @since 2022/2/16
 */
@EnableConfigurationProperties({OssProperties.class, GridFsProperties.class, AliYunProperties.class, MinIoProperties.class, LocalProperties.class})
@Import({GridFsConfig.class, AliYunConfig.class, MinIOConfig.class})
@AutoConfiguration
public class OssAutoConfiguration {
    private OssProperties ossProperties;

    @ConditionalOnMissingBean(OssHelper.class)
    @Bean
    public OssHelper ossHelper() {
        switch (StorageMode.getByName(ossProperties.getStorageMode())) {
            case GRID_FS:
                return new GridFsHelper();
            case ALI_YUN:
                return new AliYunHelper();
            case MINIO:
                return new MinIOHelper();
            default:
                return new LocalHelper();
        }
    }

    @Autowired
    public void setOssProperties(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}
