package cool.doudou.doudada.oss.core.enums;

import lombok.AllArgsConstructor;

import java.util.Arrays;
import java.util.Optional;

/**
 * StorageMode
 *
 * @author jiangcs
 * @since 2022/3/6
 */
@AllArgsConstructor
public enum StorageMode {
    /**
     * 服务器本地
     */
    LOCAL("local"),
    /**
     * MongoDB：GridFS
     */
    GRID_FS("gridFs"),
    /**
     * 阿里云
     */
    ALI_YUN("aliYun"),
    /**
     * MinIO
     */
    MINIO("minIO");

    private final String name;

    public static StorageMode getByName(String name) {
        Optional<StorageMode> optionalFirst = Arrays.stream(StorageMode.values())
                .filter((e) -> e.name.equalsIgnoreCase(name))
                .findFirst();
        return optionalFirst.orElse(null);
    }
}
