package cool.doudou.doudada.oss.core.rs;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * OssResult
 *
 * @author jiangcs
 * @since 2022/2/16
 */
@Accessors(chain = true)
@Data
public class OssResult {
    /**
     * 文件键值
     */
    private String key;
    /**
     * 文件名称
     */
    private String filename;
    /**
     * 文件内容类型
     */
    private String contentType;

    public static OssResult ok(String key, String filename, String contentType) {
        return new OssResult()
                .setKey(key)
                .setFilename(filename)
                .setContentType(contentType);
    }
}
